#echo off
echo HD-docker -------------------------------- start download
PWD=`pwd`
echo $PWD
version=0.0.1
echo $version
docker -v
user=huiduserver
echo download -------------------------------- hd-web:$version
docker pull $user/hd-web:$version
echo download --------------------------------hd-mysql:$version
docker pull $user/hd-mysql:$version
echo download -------------------------------- hd-draw:$version
docker pull $user/hd-draw:$version
echo download -------------------------------- hd-fc:$version
docker pull $user/hd-fc:$version
echo download -------------------------------- hd-nginx:$version
docker pull $user/hd-nginx:$version
echo HD-docker -------------------------------- complete download
echo HD-docker -------------------------------- start init
docker network create --subnet=177.77.0.0/26 hdnetwork
docker run -it -v $PWD/mysqlData:/docker-entrypoint-initdb.d/data --name hd-mysql-container --net hdnetwork --ip=177.77.0.2 -p 37268:37268 -d $user/hd-mysql:$version
docker run -it -v $PWD/dms-storageCopy:/root/huidu-web/dms-storage --name hd-web-container  --net hdnetwork --ip=177.77.0.3 -p 18080:18080 -p 1883:1883 -d $user/hd-web:$version
docker cp hd-web-container:/root/huidu-web/dms-storageCopy $PWD
docker restart hd-web-container
docker run -it -v $PWD/dms-storageCopy:/root/huidu-web/dms-storage --name hd-fc-container  --net hdnetwork --ip=177.77.0.4 -p 9019:9019 -d $user/hd-fc:$version
docker run -it -v $PWD/dms-storageCopy:/root/huidu-web/dms-storage --name hd-draw-container  --net hdnetwork --ip=177.77.0.5 -p 9003:9003 -d $user/hd-draw:$version
docker run -it --name hd-nginx-container  --net hdnetwork --ip=177.77.0.6 -p 8089:80  -d $user/hd-nginx:$version

ips=$(ip addr | awk '/^[0-9]+: / {}; /inet.*global/ {print gensub(/(.*)\/(.*)/, "\\1", "g", $2)}')
echo $ips
echo ${ips% }
array=(${ips// / })
ip=${array[0]}

echo $ip

cd ./dms-storageCopy && sed -i "s/127.0.0.1/${ip}/g" hdSetting.json

machineCode=$( dmidecode -t 4 | grep ID |sort -u |awk -F': ' '{print $2}')
echo $machineCode | sed 's/ //g'
code=$(echo $machineCode |  sed 's/ //g')
echo $code
sed -i "s/xxxxxx/${code}/g" hdSetting.json

echo HD-docker -------------------------------- complete init                                                              
